const { app, BrowserWindow, Tray, ipcMain,Menu } = require('electron');
const path = require('path');

let mainWindow;
let tray;

function createWindow() {
    mainWindow = new BrowserWindow({
        width: 500,
        height: 1000,
        webPreferences: {
            nodeIntegration: false,
            contextIsolation: true,
            enableRemoteModule: false,
            preload: path.join(__dirname, 'preload.js')
        }
    });

    // 隐藏默认的菜单栏
    //mainWindow.setMenu(null);

    // mainWindow.loadURL('https://supplier.wang-kang.com');
    mainWindow.loadURL('https://manager.wang-kang.com');
    //
    // 创建系统托盘
    tray = new Tray(path.join(__dirname, 'icon.ico'));
    tray.setToolTip('金瓯商旅宝');

    // 打开开发者工具（可选）
    //mainWindow.webContents.openDevTools();
    // 保留顶部菜单

}

app.whenReady().then(createWindow);

app.on('window-all-closed', () => {
    if (process.platform !== 'darwin') {
        app.quit();
    }
});

app.on('activate', () => {
    if (BrowserWindow.getAllWindows().length === 0) {
        createWindow();
    }
});

// 监听渲染进程发送的消息
ipcMain.on('new-message', (event, message) => {
    console.log(`Received message from renderer: ${message}`);

    // 让 Windows 图标闪烁
    if (!mainWindow.isFocused()) {
        mainWindow.flashFrame(true);
    }

    // 让托盘图标闪烁
    let flashTray = true;
    const flashInterval = setInterval(() => {
        tray.setImage(flashTray ? path.join(__dirname, 'icon.ico') : path.join(__dirname, 'blank.ico'));
        flashTray = !flashTray;
    }, 500);

    setTimeout(() => {
        clearInterval(flashInterval);
        tray.setImage(path.join(__dirname, 'icon.ico'));
    }, 5000); // 闪烁 5 秒后停止
});